/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.capabilities;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public interface IKnowledgeProvider
extends INBTSerializable<CompoundTag> {
    public boolean hasFullKnowledge();

    public void setFullKnowledge(boolean var1);

    public void clearKnowledge();

    default public boolean hasKnowledge(@NotNull ItemStack stack) {
        return !stack.m_41619_() && this.hasKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean hasKnowledge(@NotNull ItemInfo var1);

    default public boolean addKnowledge(@NotNull ItemStack stack) {
        return !stack.m_41619_() && this.addKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean addKnowledge(@NotNull ItemInfo var1);

    default public boolean removeKnowledge(@NotNull ItemStack stack) {
        return !stack.m_41619_() && this.removeKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean removeKnowledge(@NotNull ItemInfo var1);

    @NotNull
    public Set<ItemInfo> getKnowledge();

    @NotNull
    public IItemHandler getInputAndLocks();

    public BigInteger getEmc();

    public void setEmc(BigInteger var1);

    public void sync(@NotNull ServerPlayer var1);

    public void syncEmc(@NotNull ServerPlayer var1);

    public void syncKnowledgeChange(@NotNull ServerPlayer var1, ItemInfo var2, boolean var3);

    public void syncInputAndLocks(@NotNull ServerPlayer var1, List<Integer> var2, TargetUpdateType var3);

    public void receiveInputsAndLocks(Map<Integer, ItemStack> var1);

    public static enum TargetUpdateType {
        NONE,
        IF_NEEDED,
        ALL;

    }
}

